using System;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

using DarkStrideToolbox;


namespace MetalMarines
{
	public class DSBouncingText
	{
		#region Properties
		private const double m_cLOADINGMSG_XROTATESPEED = .01;
		private double m_nLoadingMsg_XRotateDir = m_cLOADINGMSG_XROTATESPEED;
		private double m_nLoadingMsg_XRotateAngle = 0;
		private const double m_cLOADINGMSG_YROTATESPEED = .05;
		private double m_nLoadingMsg_YRotateDir = m_cLOADINGMSG_YROTATESPEED;
		private double m_nLoadingMsg_YRotateAngle = 0;
		private const double m_cLOADINGMSG_ZROTATESPEED = .001;
		private double m_nLoadingMsg_ZRotateDir = m_cLOADINGMSG_ZROTATESPEED;
		private double m_nLoadingMsg_ZRotateAngle = 0;

		private System.Drawing.Color m_oColor = System.Drawing.Color.White;

		private DSGraphicsWrapper m_oGraphicsWrapper = null;
		private DSMesh m_oLoadingMesh = null;
		#endregion


		public DSBouncingText( DSGraphicsWrapper oGraphicsWrapper,System.Drawing.Color oColor,string sMessage )
		{
			m_oGraphicsWrapper = oGraphicsWrapper;

			m_oColor = oColor;

			m_oLoadingMesh = new DSMesh( oGraphicsWrapper.Direct3DDevice );
			m_oLoadingMesh.CreateMeshText( sMessage,10,m_oColor );
		}
		public void Advance( double nElapsedTime )
		{
			if( m_nLoadingMsg_XRotateAngle > .1 )
			{
				m_nLoadingMsg_XRotateDir = -m_cLOADINGMSG_XROTATESPEED;
			}
			if( m_nLoadingMsg_XRotateAngle < -.1 )
			{
				m_nLoadingMsg_XRotateDir = m_cLOADINGMSG_XROTATESPEED;
			}
			m_nLoadingMsg_XRotateAngle += m_nLoadingMsg_XRotateDir/2;

			if( m_nLoadingMsg_YRotateAngle > 1 )
			{
				m_nLoadingMsg_YRotateDir = -m_cLOADINGMSG_YROTATESPEED;
			}
			if( m_nLoadingMsg_YRotateAngle < -1 )
			{
				m_nLoadingMsg_YRotateDir = m_cLOADINGMSG_YROTATESPEED;
			}
			m_nLoadingMsg_YRotateAngle += m_nLoadingMsg_YRotateDir/2;

			if( m_nLoadingMsg_ZRotateAngle > .1 )
			{
				m_nLoadingMsg_ZRotateDir = -m_cLOADINGMSG_ZROTATESPEED;
			}
			if( m_nLoadingMsg_ZRotateAngle < -.1 )
			{
				m_nLoadingMsg_ZRotateDir = m_cLOADINGMSG_ZROTATESPEED;
			}
			m_nLoadingMsg_ZRotateAngle += m_nLoadingMsg_ZRotateDir;
		}
		public void Render3D()
		{
			Vector3 eyeLocation = new Vector3(0.0f,0*-5.0f,-20.0f);
			Vector3 lookAtPoint = new Vector3(0.2f*0, 0.0f,  0.0f);
			Matrix oRotate = Matrix.Identity;


			oRotate = Matrix.Translation(	-m_oLoadingMesh.MeshBounds.X / 2,
											-m_oLoadingMesh.MeshBounds.Y / 2,
											m_oLoadingMesh.MeshBounds.Z / 2 ) * 
						Matrix.RotationX( (float)m_nLoadingMsg_XRotateAngle ) * 
						Matrix.RotationX( (float)m_nLoadingMsg_YRotateAngle ) * 
						Matrix.RotationZ( (float)m_nLoadingMsg_ZRotateAngle );

			m_oGraphicsWrapper.Direct3DDevice.Transform.View = Matrix.LookAtLH( eyeLocation, lookAtPoint, new Vector3(0,1,0 ) );
			m_oGraphicsWrapper.Direct3DDevice.Transform.Projection = Matrix.PerspectiveFovLH(.78f, 1, 1, 1000);

			m_oLoadingMesh.Render( oRotate );
		}



		#region Properties
		#endregion
	}
}
